//ColocarPDFMultipage.jsx
//Un script de InDesign JavaScript 
/* @@@BUILDINFO@@@ "ColocarPDFMultipage.jsx" 3.0.0 15 Diciembre 2009
*/
//Coloca todas las páginas de un PDF multipágina.
//Modificado y traducido en 2025 con la ayuda de Gemini
//
//Para más información sobre la programación en InDesign/InCopy, consulte la documentación incluida en el SDK de Scripting
//disponible en http://www.adobe.com/devnet/indesign/sdk.html
//o visite el foro de usuarios de Scripting de InDesign en http://www.adobeforums.com
//
main();

// ==========================================================
// >>> FUNCIÓN PRINCIPAL (main) <<<
// ==========================================================
function main(){
    // Asegurarse de que la interacción del usuario (mostrar diálogos, etc.) esté activada.
    app.scriptPreferences.userInteractionLevel = UserInteractionLevels.interactWithAll;

    // 1. ESTRUCTURAS DE DATOS PARA EL DIÁLOGO DE OPCIONES
    var myCropLabels = ["MediaBox", "BleedBox", "TrimBox", "CropBox"]; 
    var myCropValues = [PDFCrop.cropMedia, PDFCrop.cropBleed, PDFCrop.cropTrim, PDFCrop.cropPDF];

    // Llamada al diálogo para obtener las preferencias (cadenas de texto)
    var myDialogResult = myGetPlacementStrings(myCropLabels, myCropValues);
    
    // Si el usuario cancela, myDialogResult será null, terminamos el script
    if (myDialogResult == null) {
        return; 
    }

    // Desestructura las cadenas de texto y la opción de recorte
    var myPDFCrop = myDialogResult.cropValue; 
    var xString = myDialogResult.xString;
    var yString = myDialogResult.yString;
    
    // Mostrar un cuadro de diálogo estándar para abrir archivo.
    var myPDFFile = File.openDialog("Seleccione un archivo PDF");
    if((myPDFFile != "")&&(myPDFFile != null)){
        var myDocument, myPage;
        
        // SE CREA O SE SELECCIONA EL DOCUMENTO
        if(app.documents.length != 0){
            var myTemp = myChooseDocument();
            myDocument = myTemp[0];
            myNewDocument = myTemp[1];
        }
        else{
            myDocument = app.documents.add();
            myNewDocument = false;
        }
        
        // 2. CONVERSIÓN DE UNIDADES (Usando UnitValue y forzando a Milímetros)
        var myPositionX = new UnitValue(xString).as(MeasurementUnits.MILLIMETERS);
        var myPositionY = new UnitValue(yString).as(MeasurementUnits.MILLIMETERS);
        
        if(myNewDocument == false){
            myPage = myChoosePage(myDocument);
        }
        else{
            myPage = myDocument.pages.item(0);
        }
        
        // Se pasan las variables de recorte y posición (ya convertidas a números)
        myPlacePDF(myDocument, myPage, myPDFFile, myPDFCrop, myPositionX, myPositionY); 
    }
}

// ==========================================================
// >>> FUNCIÓN: myGetPlacementStrings (Diálogo de Opciones) <<<
// ==========================================================
function myGetPlacementStrings(myCropLabels, myCropValues){
    // Título del diálogo: "Opciones de Colocación de PDF"
    var myDialog = app.dialogs.add({name:"Opciones de Colocación de PDF", canCancel:true});
    var myCropDropdown, myPositionXField, myPositionYField;
    
    with(myDialog){
        with(dialogColumns.add()){
            
            // 1. SELECCIÓN DE RECORTE
            with(dialogRows.add()){
                with(dialogColumns.add()){
                    staticTexts.add({staticLabel:"Recortar PDF por:"});
                }
                with(dialogColumns.add()){
                    // Seleccionar BleedBox por defecto (índice 1)
                    myCropDropdown = dropdowns.add({stringList:myCropLabels, selectedIndex:1});
                }
            }
            
            dialogRows.add(); 

            // 2. ENTRADA DE POSICIÓN X
            with(dialogRows.add()){
                with(dialogColumns.add()){
                    // Etiqueta: "Posición X (ej: 10mm):"
                    staticTexts.add({staticLabel:"Posición X (ej: 10mm):"});
                }
                with(dialogColumns.add()){
                    // Campo de texto para la posición X (por defecto '0mm')
                    myPositionXField = textEditboxes.add({editContents:"0mm", minWidth:50});
                }
            }
            
            // 3. ENTRADA DE POSICIÓN Y
            with(dialogRows.add()){
                with(dialogColumns.add()){
                    // Etiqueta: "Posición Y (ej: 10mm):"
                    staticTexts.add({staticLabel:"Posición Y (ej: 10mm):"});
                }
                with(dialogColumns.add()){
                    // Campo de texto para la posición Y (por defecto '0mm')
                    myPositionYField = textEditboxes.add({editContents:"0mm", minWidth:50});
                }
            }
        }
    }
    
    var myResult = myDialog.show();
    
    if(myResult == true){
        var selectedIndex = myCropDropdown.selectedIndex;
        
        // Devolver las cadenas de texto SIN CONVERTIR
        var xString = myPositionXField.editContents;
        var yString = myPositionYField.editContents;
            
        myDialog.destroy();
        
        return {
            cropValue: myCropValues[selectedIndex],
            xString: xString,
            yString: yString
        };
    }
    else{
        myDialog.destroy();
        return null;
    }
}

// ==========================================================
// >>> FUNCIÓN: myChooseDocument (Diálogo de Documento) <<<
// ==========================================================
function myChooseDocument(){
    var myDocumentNames = new Array;
    // Etiqueta: "Nuevo documento"
    myDocumentNames.push("Nuevo documento");
    // Obtener los nombres de los documentos abiertos
    for(var myDocumentCounter = 0;myDocumentCounter < app.documents.length; myDocumentCounter++){
        myDocumentNames.push(app.documents.item(myDocumentCounter).name);
    }
    // Título del diálogo: "Seleccione un documento"
    var myChooseDocumentDialog = app.dialogs.add({name:"Seleccione un documento", canCancel:false});
    with(myChooseDocumentDialog.dialogColumns.add()){
        with(dialogRows.add()){
            with(dialogColumns.add()){
                // Etiqueta: "Colocar PDF en:"
                staticTexts.add({staticLabel:"Colocar PDF en:"});
            }
            with(dialogColumns.add()){
                var myChooseDocumentDropdown = dropdowns.add({stringList:myDocumentNames, selectedIndex:0});
            }
        }
    }
    var myResult = myChooseDocumentDialog.show();
    if(myResult == true){
        if(myChooseDocumentDropdown.selectedIndex == 0){
            myDocument = app.documents.add();
            myNewDocument = true;
        }
        else{
            myDocument = app.documents.item(myChooseDocumentDropdown.selectedIndex-1);
            myNewDocument = false;
        }
        myChooseDocumentDialog.destroy();
    }
    else{
        myDocument = "";
        myNewDocument = "";
        myChooseDocumentDialog.destroy();
    }
    return [myDocument, myNewDocument];
}

// ==========================================================
// >>> FUNCIÓN: myChoosePage (Diálogo de Página) <<<
// ==========================================================
function myChoosePage(myDocument){
    var myPageNames = new Array;
    // Obtener los nombres de las páginas en el documento
    for(var myCounter = 0; myCounter < myDocument.pages.length;myCounter++){
        myPageNames.push(myDocument.pages.item(myCounter).name);
    }
    // Título del diálogo: "Seleccione una página"
    var myChoosePageDialog = app.dialogs.add({name:"Seleccione una página", canCancel:false});
    with(myChoosePageDialog.dialogColumns.add()){
        with(dialogRows.add()){
            with(dialogColumns.add()){
                // Etiqueta: "Colocar PDF en:"
                staticTexts.add({staticLabel:"Colocar PDF en:"});
            }
            with(dialogColumns.add()){
                var myChoosePageDropdown = dropdowns.add({stringList:myPageNames, selectedIndex:0});
            }
        }
    }
    myChoosePageDialog.show();
    var myPage = myDocument.pages.item(myChoosePageDropdown.selectedIndex);
    myChoosePageDialog.destroy();
    return myPage;
}

// ==========================================================
// >>> FUNCIÓN: myPlacePDF (Colocación del PDF) <<<
// ==========================================================
function myPlacePDF(myDocument, myPage, myPDFFile, myPDFCrop, myPositionX, myPositionY){ 
    // Variables fijas
    var myStartPage = 1;
    
    var myPDFPage;
    
    // APLICA LA VARIABLE DE RECORTE
    app.pdfPlacePreferences.pdfCrop = myPDFCrop; 
    
    var myCounter = myStartPage; 
    var myBreak = false;
    while(myBreak == false){
        if(myCounter > myStartPage){ 
            // Añadir una página después de la actual
            myPage = myDocument.pages.add(LocationOptions.after, myPage);
        }
        
        app.pdfPlacePreferences.pageNumber = myCounter;
        
        // USA LAS COORDENADAS DEL DIÁLOGO PARA LA POSICIÓN
        var myPlacedItems = myPage.place(File(myPDFFile), [myPositionX, myPositionY]);
        myPDFPage = myPlacedItems[0];
        
        if(myCounter == myStartPage){
            var myFirstPage = myPDFPage.pdfAttributes.pageNumber;
        }
        else{
            // Comprobar si hemos vuelto a la primera página del PDF (final del documento)
            if(myPDFPage.pdfAttributes.pageNumber == myFirstPage){
                myPage.remove();
                myBreak = true;
            }
        }
        myCounter = myCounter + 1;
    }
}