//PlaceMultipagePDF.jsx
//An InDesign JavaScript script
/* @@@BUILDINFO@@@ "PlaceMultipagePDF.jsx" 3.0.0 15 December 2009
*/
//Places all pages of a multipage PDF.
//Modified in 2025 with the help of Gemini
//For more information on InDesign/InCopy programming, see the documentation included with the Scripting SDK
//available at http://www.adobe.com/devnet/indesign/sdk.html
//or visit the InDesign Scripting user forum at http://www.adobeforums.com
//
main();

// ==========================================================
// >>> MAIN FUNCTION (main) <<<
// ==========================================================
function main(){
    // Ensure user interaction (showing dialogs, etc.) is enabled.
    app.scriptPreferences.userInteractionLevel = UserInteractionLevels.interactWithAll;

    // 1. DATA STRUCTURES FOR THE OPTIONS DIALOG
    var myCropLabels = ["MediaBox", "BleedBox", "TrimBox", "CropBox"]; 
    var myCropValues = [PDFCrop.cropMedia, PDFCrop.cropBleed, PDFCrop.cropTrim, PDFCrop.cropPDF];

    // Call the dialog to get preferences (text strings)
    var myDialogResult = myGetPlacementStrings(myCropLabels, myCropValues);
    
    // If the user cancels, myDialogResult will be null, we terminate the script
    if (myDialogResult == null) {
        return; 
    }

    // Destructure the text strings and the crop option
    var myPDFCrop = myDialogResult.cropValue; 
    var xString = myDialogResult.xString;
    var yString = myDialogResult.yString;
    
    // Display a standard file open dialog box.
    var myPDFFile = File.openDialog("Select a PDF file");
    if((myPDFFile != "")&&(myPDFFile != null)){
        var myDocument, myPage;
        
        // DOCUMENT IS CREATED OR SELECTED
        if(app.documents.length != 0){
            var myTemp = myChooseDocument();
            myDocument = myTemp[0];
            myNewDocument = myTemp[1];
        }
        else{
            myDocument = app.documents.add();
            myNewDocument = false;
        }
        
        // 2. UNIT CONVERSION (Using UnitValue and forcing Millimeters)
        var myPositionX = new UnitValue(xString).as(MeasurementUnits.MILLIMETERS);
        var myPositionY = new UnitValue(yString).as(MeasurementUnits.MILLIMETERS);
        
        if(myNewDocument == false){
            myPage = myChoosePage(myDocument);
        }
        else{
            myPage = myDocument.pages.item(0);
        }
        
        // Pass the crop and position variables (already converted to numbers)
        myPlacePDF(myDocument, myPage, myPDFFile, myPDFCrop, myPositionX, myPositionY); 
    }
}

// ==========================================================
// >>> FUNCTION: myGetPlacementStrings (Options Dialog) <<<
// ==========================================================
function myGetPlacementStrings(myCropLabels, myCropValues){
    // Dialog Title: "PDF Placement Options"
    var myDialog = app.dialogs.add({name:"PDF Placement Options", canCancel:true});
    var myCropDropdown, myPositionXField, myPositionYField;
    
    with(myDialog){
        with(dialogColumns.add()){
            
            // 1. CROP SELECTION
            with(dialogRows.add()){
                with(dialogColumns.add()){
                    staticTexts.add({staticLabel:"Crop PDF by:"});
                }
                with(dialogColumns.add()){
                    // Select BleedBox by default (index 1)
                    myCropDropdown = dropdowns.add({stringList:myCropLabels, selectedIndex:1});
                }
            }
            
            dialogRows.add(); 

            // 2. X POSITION INPUT
            with(dialogRows.add()){
                with(dialogColumns.add()){
                    // Label: "X Position (e.g., 10mm):"
                    staticTexts.add({staticLabel:"X Position (e.g., 10mm):"});
                }
                with(dialogColumns.add()){
                    // Text field for X position (default '0mm')
                    myPositionXField = textEditboxes.add({editContents:"0mm", minWidth:50});
                }
            }
            
            // 3. Y POSITION INPUT
            with(dialogRows.add()){
                with(dialogColumns.add()){
                    // Label: "Y Position (e.g., 10mm):"
                    staticTexts.add({staticLabel:"Y Position (e.g., 10mm):"});
                }
                with(dialogColumns.add()){
                    // Text field for Y position (default '0mm')
                    myPositionYField = textEditboxes.add({editContents:"0mm", minWidth:50});
                }
            }
        }
    }
    
    var myResult = myDialog.show();
    
    if(myResult == true){
        var selectedIndex = myCropDropdown.selectedIndex;
        
        // Return the text strings UNCONVERTED
        var xString = myPositionXField.editContents;
        var yString = myPositionYField.editContents;
            
        myDialog.destroy();
        
        return {
            cropValue: myCropValues[selectedIndex],
            xString: xString,
            yString: yString
        };
    }
    else{
        myDialog.destroy();
        return null;
    }
}

// ==========================================================
// >>> FUNCTION: myChooseDocument (Document Dialog) <<<
// ==========================================================
function myChooseDocument(){
    var myDocumentNames = new Array;
    // Label: "New Document"
    myDocumentNames.push("New Document");
    // Get the names of open documents
    for(var myDocumentCounter = 0;myDocumentCounter < app.documents.length; myDocumentCounter++){
        myDocumentNames.push(app.documents.item(myDocumentCounter).name);
    }
    // Dialog Title: "Select a Document"
    var myChooseDocumentDialog = app.dialogs.add({name:"Select a Document", canCancel:false});
    with(myChooseDocumentDialog.dialogColumns.add()){
        with(dialogRows.add()){
            with(dialogColumns.add()){
                // Label: "Place PDF into:"
                staticTexts.add({staticLabel:"Place PDF into:"});
            }
            with(dialogColumns.add()){
                var myChooseDocumentDropdown = dropdowns.add({stringList:myDocumentNames, selectedIndex:0});
            }
        }
    }
    var myResult = myChooseDocumentDialog.show();
    if(myResult == true){
        if(myChooseDocumentDropdown.selectedIndex == 0){
            myDocument = app.documents.add();
            myNewDocument = true;
        }
        else{
            myDocument = app.documents.item(myChooseDocumentDropdown.selectedIndex-1);
            myNewDocument = false;
        }
        myChooseDocumentDialog.destroy();
    }
    else{
        myDocument = "";
        myNewDocument = "";
        myChooseDocumentDialog.destroy();
    }
    return [myDocument, myNewDocument];
}

// ==========================================================
// >>> FUNCTION: myChoosePage (Page Dialog) <<<
// ==========================================================
function myChoosePage(myDocument){
    var myPageNames = new Array;
    // Get the names of pages in the document
    for(var myCounter = 0; myCounter < myDocument.pages.length;myCounter++){
        myPageNames.push(myDocument.pages.item(myCounter).name);
    }
    // Dialog Title: "Select a Page"
    var myChoosePageDialog = app.dialogs.add({name:"Select a Page", canCancel:false});
    with(myChoosePageDialog.dialogColumns.add()){
        with(dialogRows.add()){
            with(dialogColumns.add()){
                // Label: "Place PDF on Page:"
                staticTexts.add({staticLabel:"Place PDF on Page:"});
            }
            with(dialogColumns.add()){
                var myChoosePageDropdown = dropdowns.add({stringList:myPageNames, selectedIndex:0});
            }
        }
    }
    myChoosePageDialog.show();
    var myPage = myDocument.pages.item(myChoosePageDropdown.selectedIndex);
    myChoosePageDialog.destroy();
    return myPage;
}

// ==========================================================
// >>> FUNCTION: myPlacePDF (PDF Placement) <<<
// ==========================================================
function myPlacePDF(myDocument, myPage, myPDFFile, myPDFCrop, myPositionX, myPositionY){ 
    // Fixed variables
    var myStartPage = 1;
    
    var myPDFPage;
    
    // APPLY THE CROP VARIABLE
    app.pdfPlacePreferences.pdfCrop = myPDFCrop; 
    
    var myCounter = myStartPage; 
    var myBreak = false;
    while(myBreak == false){
        if(myCounter > myStartPage){ 
            // Add a page after the current one
            myPage = myDocument.pages.add(LocationOptions.after, myPage);
        }
        
        app.pdfPlacePreferences.pageNumber = myCounter;
        
        // USE THE DIALOG COORDINATES FOR POSITION
        var myPlacedItems = myPage.place(File(myPDFFile), [myPositionX, myPositionY]);
        myPDFPage = myPlacedItems[0];
        
        if(myCounter == myStartPage){
            var myFirstPage = myPDFPage.pdfAttributes.pageNumber;
        }
        else{
            // Check if we have wrapped back to the first page of the PDF (end of document)
            if(myPDFPage.pdfAttributes.pageNumber == myFirstPage){
                myPage.remove();
                myBreak = true;
            }
        }
        myCounter = myCounter + 1;
    }
}